####################################################################################################
# Script
####################################################################################################
#  
#  AUTHOR: ...
#
#  E-MAIL: ...
#
#  PROJECT/TITLE: ...
#
#  DATE: ...
#
#  DATA: ...
#
####################################################################################################
#-------------------------------------------
# Function to compute two stage least squares:
#-------------------------------------------
twosls <- function(y,x,z, constant = T){ 
    # y : the dependent variable
    # x : a matrix of explanatory variables
    # z : a matrix of instruments (may include some or all of the elements of x)
    # constant : whether x contains a constant. default is true.
    xfit <- lm(x~z)$fitted.values
    if(constant==T){
      model <- lm(y ~ xfit-1)
      model$residuals <- y - x%*%model$coef
    }
    model <- lm(y ~ xfit)
    model$residuals <- y - cbind(1,x)%*%model$coef
    model
  }